/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.shop.condition;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryCondition;

public class ShopFTBQuestsCondition
extends AbstractShopEntryCondition {
    protected List<String> questID = new ArrayList<String>();

    public ShopFTBQuestsCondition() {
    }

    protected ShopFTBQuestsCondition(List<String> questID) {
        this.questID = questID;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isLocked() {
        TeamData data = TeamData.get((Player)Minecraft.m_91087_().f_91074_);
        Iterator<String> iterator = this.questID.iterator();
        if (iterator.hasNext()) {
            String s = iterator.next();
            Quest quest = ClientQuestFile.INSTANCE.getQuest(ClientQuestFile.parseCodeString((String)s));
            if (quest != null) {
                return !data.isCompleted((QuestObject)quest);
            }
            return false;
        }
        return false;
    }

    @Override
    public AbstractShopEntryCondition copy() {
        return new ShopFTBQuestsCondition(this.questID);
    }

    @Override
    public void getConfig(ConfigGroup config) {
        config.addList("questID", this.questID, (ConfigValue)new StringConfig(null), (Object)"");
    }

    @Override
    public String getModId() {
        return "ftbquests";
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        ListTag d1 = new ListTag();
        for (String gameStage : this.questID) {
            d1.add((Object)StringTag.m_129297_((String)gameStage));
        }
        nbt.m_128365_("questID", (Tag)d1);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.questID.clear();
        ListTag d1 = (ListTag)nbt.m_128423_("questID");
        for (Tag tag : d1) {
            StringTag f1 = (StringTag)tag;
            this.questID.add(f1.m_7916_());
        }
    }

    @Override
    public String getId() {
        return "ftbquestConditions";
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryCondition> {
        @Override
        public AbstractShopEntryCondition createDefaultInstance() {
            return new ShopFTBQuestsCondition(new ArrayList<String>());
        }
    }
}

